		clear all, close all

	fsample = 1000; M = 5;	
	F = [0,0.08,0.15,1]; A = [0,1,0,0]; x = fir2(128,F,A); % Input signal
	[X,f] = freqz(x,1,1000,fsample);	% Input spectrum
	subplot(4,1,1);  PLOT_ABS_f(f, abs(X), 500, 'X')
 	
	h = REMEZ_FIR(89,[0,70/500,100/500,1]*pi,[1,1,0,0], [1,10,10], 'm'); % Anti-aliasing filter
	[H,f] = freqz(h,1,1000,fsample); 
	subplot(4,1,2), plot(f, H_2_MAG(H),'linewidth',2)
	ylabel(['{|\itH}|  [dB]'],'FontName', 'times','FontSize',16);
	axis([0,fsample/2,-80,0]), grid on
	
	P = reshape(h,M,length(h)/M);	% Polyphase decomposition
	x0 = [x(1:M:length(x)),0]; 		% Commutator: 0, 4, 3, 2, 1	
	x1 = [0,x(5:M:length(x)),0];	% Make the length of x0 through x4 equal
	x2 = [0,x(4:M:length(x))];
	x3 = [0,x(3:M:length(x))]; 
	x4 = [0,x(2:M:length(x))];
	y0 = filter(P(1,:),1,x0); 
	y1 = filter(P(2,:),1,x1); 
	y2 = filter(P(3,:),1,x2); 
	y3 = filter(P(4,:),1,x3); 
	y4 = filter(P(5,:),1,x4); 
	[Y,f] = freqz(y0+y1+y2+y3+y4,1,500, 200);
	subplot(4,1,3),  PLOT_ABS_f(f, abs(Y), 100, 'Y')
	xlabel('{\itf }   [Hz]','FontName', 'times','FontSize',14);	
